USE bd_locadora
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[avaliacao]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[avaliacao]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cargo]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[cargo]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[categoria]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[categoria]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cliente]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[cliente]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[diretor]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[diretor]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[diretor_filme]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[diretor_filme]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[filme]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[filme]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[funcionario]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[funcionario]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[genero]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[genero]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[item]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[item]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[item_locacao]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[item_locacao]
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[locacao]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[locacao]
GO

CREATE TABLE [dbo].[avaliacao] (
	[cod_avaliacao] [int] NOT NULL ,
	[nota] [decimal](4, 2) NULL ,
	[dtc_atualizacao] [datetime] NOT NULL ,
	[cod_filme] [smallint] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[cargo] (
	[cod_cargo] [tinyint] NOT NULL ,
	[nom_cargo] [varchar] (20) NOT NULL ,
	[dtc_atualizacao] [datetime] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[categoria] (
	[cod_categoria] [tinyint] NOT NULL ,
	[nom_categoria] [char] (3) NOT NULL ,
	[dtc_atualizacao] [datetime] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[cliente] (
	[cod_cliente] [smallint] NOT NULL ,
	[nom_cliente] [varchar] (50) NOT NULL ,
	[cpf_cliente] [bigint] NULL ,
	[rg_cliente] [bigint] NULL ,
	[dtc_nascimento] [smalldatetime] NULL ,
	[dtc_cadastramento] [smalldatetime] NOT NULL ,
	[sexo] [char] (1) NULL ,
	[estado_civil] [char] (10) NULL ,
	[nacionalidade] [varchar] (20) NULL ,
	[dtc_atualizacao] [datetime] NOT NULL ,
	[cod_responsavel] [smallint] NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[diretor] (
	[cod_diretor] [tinyint] NOT NULL ,
	[nom_diretor] [varchar] (50) NOT NULL ,
	[dtc_atualizacao] [datetime] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[diretor_filme] (
	[cod_diretor] [tinyint] NOT NULL ,
	[cod_filme] [smallint] NOT NULL ,
	[dtc_atualizacao] [datetime] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[filme] (
	[cod_filme] [smallint] NOT NULL ,
	[tit_filme] [varchar] (50) NOT NULL ,
	[dtc_atualizacao] [datetime] NOT NULL ,
	[cod_genero] [tinyint] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[funcionario] (
	[cod_funcionario] [tinyint] NOT NULL ,
	[nom_funcionario] [varchar] (50) NOT NULL ,
	[dtc_admissao] [smalldatetime] NOT NULL ,
	[dtc_atualizacao] [datetime] NOT NULL ,
	[cod_cargo] [tinyint] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[genero] (
	[cod_genero] [tinyint] NOT NULL ,
	[nom_genero] [varchar] (20) NOT NULL ,
	[dtc_atualizacao] [datetime] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[item] (
	[cod_filme] [smallint] NOT NULL ,
	[seq_item] [tinyint] NOT NULL ,
	[val_item] [decimal](3, 2) NOT NULL ,
	[sts_item] [char] (10) NOT NULL ,
	[dtc_atualizacao] [datetime] NOT NULL ,
	[cod_categoria] [tinyint] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[item_locacao] (
	[cod_filme] [smallint] NOT NULL ,
	[seq_item] [tinyint] NOT NULL ,
	[cod_locacao] [int] NOT NULL ,
	[dtc_atualizacao] [datetime] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[locacao] (
	[cod_locacao] [int] NOT NULL ,
	[dtc_locacao] [datetime] NOT NULL ,
	[dtc_devolucao_prevista] [smalldatetime] NOT NULL ,
	[dtc_devolucao] [datetime] NULL ,
	[val_locacao] [decimal](3, 2) NOT NULL ,
	[dtc_atualizacao] [datetime] NOT NULL ,
	[cod_funcionario] [tinyint] NOT NULL ,
	[cod_cliente] [smallint] NOT NULL 
) ON [PRIMARY]
GO

ALTER TABLE [dbo].[avaliacao] ADD 
	CONSTRAINT [df_avaliacao01] DEFAULT (getdate()) FOR [dtc_atualizacao],
	CONSTRAINT [ix_avaliacao01] PRIMARY KEY  NONCLUSTERED 
	(
		[cod_avaliacao]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[cargo] ADD 
	CONSTRAINT [df_cargo01] DEFAULT (getdate()) FOR [dtc_atualizacao],
	CONSTRAINT [ix_cargo01] PRIMARY KEY  NONCLUSTERED 
	(
		[cod_cargo]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[categoria] ADD 
	CONSTRAINT [df_categoria01] DEFAULT (getdate()) FOR [dtc_atualizacao],
	CONSTRAINT [ix_categoria01] PRIMARY KEY  NONCLUSTERED 
	(
		[cod_categoria]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[cliente] ADD 
	CONSTRAINT [df_cliente01] DEFAULT (getdate()) FOR [dtc_atualizacao],
	CONSTRAINT [ix_cliente01] PRIMARY KEY  NONCLUSTERED 
	(
		[cod_cliente]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[diretor] ADD 
	CONSTRAINT [df_diretor01] DEFAULT (getdate()) FOR [dtc_atualizacao],
	CONSTRAINT [ix_diretor01] PRIMARY KEY  NONCLUSTERED 
	(
		[cod_diretor]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[diretor_filme] ADD 
	CONSTRAINT [df_diretor_filme01] DEFAULT (getdate()) FOR [dtc_atualizacao],
	CONSTRAINT [ix_diretor_filme01] PRIMARY KEY  NONCLUSTERED 
	(
		[cod_diretor],
		[cod_filme]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[filme] ADD 
	CONSTRAINT [df_filme01] DEFAULT (getdate()) FOR [dtc_atualizacao],
	CONSTRAINT [ix_filme01] PRIMARY KEY  NONCLUSTERED 
	(
		[cod_filme]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[funcionario] ADD 
	CONSTRAINT [df_funcionario01] DEFAULT (getdate()) FOR [dtc_atualizacao],
	CONSTRAINT [ix_funcionario01] PRIMARY KEY  NONCLUSTERED 
	(
		[cod_funcionario]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[genero] ADD 
	CONSTRAINT [df_genero01] DEFAULT (getdate()) FOR [dtc_atualizacao],
	CONSTRAINT [ix_genero01] PRIMARY KEY  NONCLUSTERED 
	(
		[cod_genero]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[item] ADD 
	CONSTRAINT [df_item01] DEFAULT (getdate()) FOR [dtc_atualizacao],
	CONSTRAINT [ix_item01] PRIMARY KEY  NONCLUSTERED 
	(
		[cod_filme],
		[seq_item]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[item_locacao] ADD 
	CONSTRAINT [df_item_locacao01] DEFAULT (getdate()) FOR [dtc_atualizacao],
	CONSTRAINT [ix_item_locacao01] PRIMARY KEY  NONCLUSTERED 
	(
		[cod_filme],
		[seq_item],
		[cod_locacao]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[locacao] ADD 
	CONSTRAINT [df_locacao01] DEFAULT (getdate()) FOR [dtc_atualizacao],
	CONSTRAINT [ix_locacao01] PRIMARY KEY  NONCLUSTERED 
	(
		[cod_locacao]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[avaliacao] ADD 
	CONSTRAINT [fk_avaliacao_filme] FOREIGN KEY 
	(
		[cod_filme]
	) REFERENCES [dbo].[filme] (
		[cod_filme]
	)
GO

ALTER TABLE [dbo].[diretor_filme] ADD 
	CONSTRAINT [fk_diretor_filme_diretor01] FOREIGN KEY 
	(
		[cod_diretor]
	) REFERENCES [dbo].[diretor] (
		[cod_diretor]
	),
	CONSTRAINT [fk_diretor_filme_filme] FOREIGN KEY 
	(
		[cod_filme]
	) REFERENCES [dbo].[filme] (
		[cod_filme]
	)
GO

ALTER TABLE [dbo].[filme] ADD 
	CONSTRAINT [fk_filme_genero] FOREIGN KEY 
	(
		[cod_genero]
	) REFERENCES [dbo].[genero] (
		[cod_genero]
	)
GO

ALTER TABLE [dbo].[funcionario] ADD 
	CONSTRAINT [fk_funcionario_cargo] FOREIGN KEY 
	(
		[cod_cargo]
	) REFERENCES [dbo].[cargo] (
		[cod_cargo]
	)
GO

ALTER TABLE [dbo].[item] ADD 
	CONSTRAINT [fk_item_categoria] FOREIGN KEY 
	(
		[cod_categoria]
	) REFERENCES [dbo].[categoria] (
		[cod_categoria]
	),
	CONSTRAINT [fk_item_filme] FOREIGN KEY 
	(
		[cod_filme]
	) REFERENCES [dbo].[filme] (
		[cod_filme]
	)
GO

ALTER TABLE [dbo].[item_locacao] ADD 
	CONSTRAINT [fk_item_locacao_item] FOREIGN KEY 
	(
		[cod_filme],
		[seq_item]
	) REFERENCES [dbo].[item] (
		[cod_filme],
		[seq_item]
	),
	CONSTRAINT [fk_item_locacao_locacao] FOREIGN KEY 
	(
		[cod_locacao]
	) REFERENCES [dbo].[locacao] (
		[cod_locacao]
	)
GO

ALTER TABLE [dbo].[locacao] ADD 
	CONSTRAINT [fk_locacao_cliente] FOREIGN KEY 
	(
		[cod_cliente]
	) REFERENCES [dbo].[cliente] (
		[cod_cliente]
	),
	CONSTRAINT [fk_locacao_funcionario] FOREIGN KEY 
	(
		[cod_funcionario]
	) REFERENCES [dbo].[funcionario] (
		[cod_funcionario]
	)
GO
